<?php

defined('TEMPLAZA_FRAMEWORK') or exit();

use TemPlazaFramework\Post_TypeFunctions;

if(!class_exists('TemplazaFramework_MetaBox_Restaurant')){
    class TemplazaFramework_MetaBox_Restaurant extends TemplazaFramework_MetaBox{
        // phpcs:disable WordPress.DB.SlowDBQuery.slow_db_query_meta_key
        public function register(){
            // Get all post types without templaza_style
            $metaboxes[] = array(
                'id'            => 'restaurant-options',
                'title'         => esc_html__( 'Restaurant Options', 'templaza-framework' ),
                'post_types'    => array('restaurant'),
                'position'      => 'normal', // normal, advanced, side
                'priority'      => 'default', // high, core, default, low - Priorities of placement
                'store_each'    => true, // Store value of each fields to each post meta
                'sections'      => array(
                    array(
                        'fields' => array(
                            array(
                                'id'        => 'gallery',
                                'type'      => 'gallery',
                                'title'     => esc_html__('Gallery', 'templaza-framework'),
                            ),
                            array(
                                'id'        => 'price',
                                'type'      => 'text',
                                'title'     => esc_html__( 'Price', 'templaza-framework' ),
                            ),
                        ),
                    ),
                ),
            );

            return $metaboxes;
        }

        public function hooks()
        {
            parent::hooks(); // TODO: Change the autogenerated stub

            add_filter("redux/options/{$this->prefix}templaza-options/wordpress_data/translate/post_type_value",
                array($this, 'meta_box_basic_post_type_value'), 10, 2);


            $post_type  = $this -> post_type -> get_post_type();

            if(post_type_exists($post_type) && $this -> post_type ->  get_current_screen_post_type() == $post_type){
                // Add header column to post type list
                if(method_exists($this,'post_type_table_head')) {
                    add_filter('manage_'.$post_type.'_posts_columns', array($this, 'post_type_table_head'));
                }
            }

        }

        /*
         * Add columns for header custom post type in list page
         * @param array $columns
         * */
        public function post_type_table_head($columns){
            $columns = array(
                "cb"                 => "<input type=\"checkbox\" />",
                "title"              => esc_html__("Title", 'templaza-framework'),
//                "home"             => esc_html__("Default",'templaza-framework'),
                "date"               => esc_html__("Date",'templaza-framework')
            );
            return $columns;
        }

        /*
         * Add columns for content custom post type in list page
         * @param string $column_name
         * @param string $post_id
         * */
        public function post_type_table_content($column_name, $post_id ){
            // phpcs:disable WordPress.Security.EscapeOutput.OutputNotEscaped
            if ($column_name == 'home') {
                $home   = get_post_meta($post_id,'home', true);
                $action = $this -> post_type -> get_post_type().'_set_default';
                $nonce  = wp_create_nonce( $action );
                $href   = 'admin.php?action='.$action.'&post='.$post_id.'&_wpnonce='
                    .$nonce.'" class="button button-micro'.($home?' disabled':'');
                if($home){
                    $href   = 'javascript:void();';
                }
                echo '<a href="'.$href.'" class="button button-micro'.($home?' disabled':'').'"'.($home?' disabled':'').'>';
                if($home){
                    echo '<span class="dashicons dashicons-star-filled featured"></span>';
                }else{
                    echo '<span class="dashicons dashicons-star-empty"></span>';
                }
                echo '</a>';
            }
        }

        /*
         * Order by query for custom post type in list page
         * @param array $vars
         * */
        public function post_type_orderby( $vars ) {
            if ( isset( $vars['orderby'] ) && 'home' == $vars['orderby'] ) {
                $vars = array_merge( $vars, array(
                    'meta_key' => 'home',
                    'orderby' => 'meta_value'
                ) );
            }

            return $vars;
        }

        /*
         * Reset value of select field with data is post
         * */
        public function meta_box_basic_post_type_value($value, $post_type){
            if(is_array($value)){
                return array();
            }else{
                return '';
            }
        }

    }
}